<?php
include 'header.php';

// Get and sanitise the search query
$query = isset($_GET['query']) ? trim($_GET['query']) : '';
$safeQuery = htmlspecialchars($query, ENT_QUOTES, 'UTF-8');
?>

<main id="main-content">
    <section class="search-results">
        <h1>Search Results</h1>

        <?php if ($query === ''): ?>
            <p>Please enter a search term.</p>
        <?php else: ?>
            <p>
                Showing results for:
                <strong><?php echo $safeQuery; ?></strong>
            </p>

            <div class="product-list">

                <?php
                // Example product list (replace with DB later)
                $products = [
                    ['id' => 1, 'name' => 'Running gears', 'price' => 389.99, 'image' => 'images/1.jpg'],
                    ['id' => 2, 'name' => 'Sports Watch', 'price' => 1129.99, 'image' => 'images/2.jpg'],
                    ['id' => 3, 'name' => 'Silver Watch', 'price' => 159.99, 'image' => 'images/3.jpg'],
                    ['id' => 4, 'name' => 'Running Shoes', 'price' => 139.99, 'image' => 'images/6.jpg'],
                ];

                $found = false;

                foreach ($products as $product) {
                    if (stripos($product['name'], $query) !== false) {
                        $found = true;
                        ?>
                        <div class="product">
                            <img src="<?php echo $product['image']; ?>" alt="<?php echo htmlspecialchars($product['name']); ?>">
                            <h2><?php echo htmlspecialchars($product['name']); ?></h2>
                            <p>$<?php echo number_format($product['price'], 2); ?></p>
                            <a href="product.php?id=<?php echo $product['id']; ?>" class="product-link">
                                View Details
                            </a>
                        </div>
                        <?php
                    }
                }

                if (!$found) {
                    echo '<p>No products found matching your search.</p>';
                }
                ?>

            </div>
        <?php endif; ?>
    </section>
</main>

<?php include 'footer.php'; ?>
