<?php
session_start();

// Check if the user is logged in and is an admin
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Example: Only admin can access CMS
// Assuming there's an 'is_admin' flag stored in the session for simplicity
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] !== true) {
    echo "Access denied. You must be an admin to access this page.";
    exit();
}

// Database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "sports_warehouse";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Handle form submission to add a new product
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $product_name = $_POST['product_name'];
    $product_price = $_POST['product_price'];
    $product_description = $_POST['product_description'];

    // Insert product into the database
    $stmt = $conn->prepare("INSERT INTO products (name, price, description) VALUES (?, ?, ?)");
    $stmt->bind_param("sds", $product_name, $product_price, $product_description);

    if ($stmt->execute()) {
        echo "Product added successfully!";
    } else {
        echo "Error adding product: " . $conn->error;
    }

    $stmt->close();
}

?>

<?php 
include 'header.php';
?>

    <main>
        <h1>Welcome to the CMS, <?php echo htmlspecialchars($_SESSION['user_name']); ?>!</h1>
        <p>Manage the content of Sports Warehouse here.</p>

        <!-- Add Product Form -->
        <section>
            <h2>Add New Product</h2>
            <form action="cms.php" method="POST">
                <label for="product_name">Product Name:</label>
                <input type="text" id="product_name" name="product_name" required>

                <label for="product_price">Product Price:</label>
                <input type="number" step="0.01" id="product_price" name="product_price" required>

                <label for="product_description">Product Description:</label>
                <textarea id="product_description" name="product_description" required></textarea>

                <button type="submit">Add Product</button>
            </form>
        </section>

        <!-- Manage Other Sections like Blogs and Announcements -->
        <!-- You can add similar forms for managing blogs, announcements, etc. -->

    </main>
<?php 
 include 'footer.php';
 ?>
