<?php 
include 'header.php';
?>
    <main id ="main-content">
        <section class="hero">
            <h1>Welcome to Sports Warehouse</h1>
            <p>Your one-stop shop for athletic clothing, sports equipment, and accessories.</p>
            <a href="catalog.php" class="cta-button">Shop Now</a>
        </section>

        <section class="features">
            <div class="feature">
                <h2>User Registration & Login</h2>
                <p>Secure registration and login for personalized shopping experience.</p>
            </div>
            <div class="feature">
                <h2>Product Catalog & Search</h2>
                <p>Browse our extensive catalog with advanced search and filtering options.</p>
            </div>
            <div class="feature">
                <h2>Shopping Cart & Checkout</h2>
                <p>Manage your cart and checkout seamlessly with multiple payment options.</p>
            </div>
            <div class="feature">
                <h2>Content Management</h2>
                <p>Admin-friendly system for updating product details, blogs, and announcements.</p>
            </div>
            <div class="feature">
                <h2>Secure System Boundaries</h2>
                <p>Third-party payment integration with secure, company-hosted data management.</p>
            </div>
        </section>

        <section class="featured-products">
            <h2>Featured Products</h2>
            <div class="product-list">
                <div class="product">
                    <img src="images/1.jpg" alt="Product 1">
                    <h3>Product 1</h3>
                    <p>$20.00</p>
                    <a href="product.php?id=1" class="product-link">View Details</a>
                </div>
                <div class="product">
                    <img src="images/2.jpg" alt="Product 2">
                    <h3>Product 2</h3>
                    <p>$25.00</p>
                    <a href="product.php?id=2" class="product-link">View Details</a>
                </div>
            </div>
           <form action="search.php" method="get" class="product-search">
  <input id="search-input" type="text" name="query" placeholder="Search products..." aria-label="Search for a product">
  <button type="submit">Search</button>
</form>
        </section>
    </main>

 <?php 
 include 'footer.php';
 ?>
